PSCAD 4.2.0

Settings
 {
 Id = "976141504.1144681955"
 Author = "jayas.jayas"
 Desc = "Series Parallel Transmission Lines"
 Arch = "windows"
 Options = 0
 Build = 19
 Warn = 7
 Check = 15
 Libs = ""
 Source = ""
 RunInfo = 
  {
  Fin = 0.5
  Step = 5e-005
  Plot = 5e-005
  Chat = 0.001
  Brch = 0.0005
  Lat = 100
  Options = 0
  Advanced = 511
  Debug = 0
  StartFile = ""
  OFile = "noname.out"
  SFile = "noname.snp"
  SnapTime = 0.3
  Mruns = 10
  Mrunfile = 0
  StartType = 0
  PlotType = 0
  SnapType = 0
  MrunType = "mrun"
  }


Global_Consts = 
  {
  f = 60.0 [Hz]
  }

 }

Definitions
 {
 Module("Plots_B1")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-18,-4,21,-4)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Text(1,-28,"Plots")
   Text(3,24,"B1 B3")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([18,18],0)
    {
    Title = "Plots at B1"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [18,18]
    Icon = [18,18]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63571344,"V1a",0,,,)
     Curve(63401680,"V1b",1,,,)
     Curve(63379728,"V1c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(63456408,"I1a",0,,,)
     Curve(63472728,"I1b",1,,,)
     Curve(63459320,"I1c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(63463072,"I10",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(63391016,"Br1a",0,,,1)
     Curve(63404456,"Br1b",1,,,1)
     Curve(63445520,"Br1c",2,,,1)
     }
    }
   -Plot-([792,18],0)
    {
    Title = "Plots at B3"
    Draw = 1
    Area = [0,0,756,1170]
    Posn = [792,18]
    Icon = [-1,-1]
    Extents = 0,0,756,1170
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,756,282],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63507704,"V3a",0,,,)
     Curve(63510536,"V3b",1,,,)
     Curve(63513448,"V3c",2,,,)
     }
    Graph([0,282],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(63516360,"I3a",0,,,)
     Curve(63519440,"I3b",1,,,)
     Curve(63522328,"I3c",2,,,)
     }
    Graph([0,563],[0,0,756,281],"Current")
     {
     Options = 9
     Units = ""
     Curve(63525240,"I30",0,,,)
     }
    PGraph([0,844],[0,0,756,263],"PolyGraph")
     {
     Options = 2
     Curve(63545664,"Br3a",0,,,1)
     Curve(63548608,"Br3b",1,,,1)
     Curve(63551384,"Br3c",2,,,1)
     }
    }
   }
  }
 Module("Controls")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   Output("BRKR",36,-36)
    {
    Type = Integer
    Dim  = [4]
    }
   Input("Flt_en",36,18)
    {
    Type = Integer
    }
   Output("FLT",36,0)
    {
    Type = Integer
    }
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Pen(Gray)
   Line(27,28,27,-43)
   Brush(,Silver)
   Rectangle(0,-13,3,0)
   Brush(,Gray)
   Rectangle(-3,-10,6,-7)
   Text(1,25,"Controls")
   Pen(Black)
   Line(27,18,36,18)
   Line(27,-36,36,-36)
   Line(27,0,36,0)
   Pen(ByNode)
   Brush(Hollow)
   Rectangle(-4,-18,7,3)
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   0.datalabel([1296,324],3,0,-1)
    {
    Name = "B1T2"
    }
   0.datalabel([1296,378],3,0,-1)
    {
    Name = "B2T1"
    }
   0.datalabel([1296,432],3,0,-1)
    {
    Name = "B2T2"
    }
   -Wire-([540,684],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([576,684],0,0,-1)
    {
    Name = "Tfs"
    }
   0.datalabel([576,720],0,0,-1)
    {
    Name = "Tfd"
    }
   -ControlPanel-([18,396],0)
    {
    Name = "SOURCE 2"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(63617832)
    Meter(63685024)
    Slider(63620936)
    Meter(63585696)
    Meter(63423184)
    Meter(63450856)
    Meter(63559992)
    Meter(63562904)
    }
   -Sticky-([522,108],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 522,108,684,216
    Alignment = 0
    Style = 1
    Arrow = 64
    Color = 0,15792890
    Text = "\
Adjust phase angle to obtain
the correct power flow. Adjust
voltage to obtain the matching
VAR flow at each end."
    }
   0.datalabel([1296,648],3,0,-1)
    {
    Name = "B3T1"
    }
   0.datalabel([1296,702],3,0,-1)
    {
    Name = "B3T2"
    }
   0.datalabel([1296,756],3,0,-1)
    {
    Name = "B4T1"
    }
   -Wire-([18,594],0,0,-1)
    {
    Vertex="0,0;1026,0"
    }
   -Wire-([1062,936],0,0,-1)
    {
    Vertex="0,0;432,0"
    }
   -Sticky-([1098,954],0)
    {
    Name = ""
    Font = 1
    Bounds = 1098,954,1206,990
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Exports to Main Page"
    }
   0.datalabel([1170,1008],6,0,-1)
    {
    Name = "B1"
    }
   0.datalabel([1170,1026],6,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([1170,1044],6,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([1170,1062],6,0,-1)
    {
    Name = "B4"
    }
   -Sticky-([1098,144],0)
    {
    Name = ""
    Font = 1
    Bounds = 1098,144,1206,180
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "BREAKER CONTROLS"
    }
   -Sticky-([1260,144],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 1260,144,1422,216
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Adjust breaker clearing time (T1)
and reclose time (T2) if needed."
    }
   -Wire-([540,720],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1044,108],0,0,-1)
    {
    Vertex="0,0;0,1080"
    }
   -ControlPanel-([1098,252],0)
    {
    Name = "B1 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(62971320)
    Slider(62920392)
    }
   -ControlPanel-([1098,396],0)
    {
    Name = "B2 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(62917672)
    Slider(62914584)
    }
   0.datalabel([1296,810],3,0,-1)
    {
    Name = "B4T2"
    }
   0.tbreakn([1368,270],4,0,20)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B1T1"
    TO2 = "B1T2"
    }
   0.tbreakn([1368,828],4,0,140)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B4T1"
    TO2 = "B4T2"
    }
   0.var([1260,432],0,62914584,50)
    {
    Name = "B2T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1260,378],0,62917672,40)
    {
    Name = "B2T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   0.var([1260,324],0,62920392,30)
    {
    Name = "B1T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -ControlPanel-([1098,630],0)
    {
    Name = "B3 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(62967568)
    Slider(62964712)
    }
   -ControlPanel-([1098,774],0)
    {
    Name = "B4 Timing"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(62961856)
    Slider(62958712)
    }
   0.var([1260,810],0,62958712,130)
    {
    Name = "B4T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1260,756],0,62961856,120)
    {
    Name = "B4T1"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "0.36"
    Units = "s"
    Collect = "1"
    }
   0.var([1260,702],0,62964712,110)
    {
    Name = "B3T2"
    Group = ""
    Display = "0"
    Max = "2.0"
    Min = "0.0"
    Value = "2.0"
    Units = "s"
    Collect = "1"
    }
   0.var([1260,648],0,62967568,90)
    {
    Name = "B3T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "0.35"
    Units = "s"
    Collect = "1"
    }
   0.datalabel([1296,270],3,0,-1)
    {
    Name = "B1T1"
    }
   0.var([1260,270],0,62971320,10)
    {
    Name = "B1T1"
    Group = ""
    Display = "0"
    Max = "2"
    Min = "0.0"
    Value = "2.0"
    Units = ""
    Collect = "1"
    }
   -Wire-([1404,306],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   0.logic([1440,306],0,0,160)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1404,378],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1404,414],0,0,-1)
    {
    Vertex="0,0;0,54"
    }
   -Wire-([1350,360],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1476,414],4,0,-1)
    {
    Name = "B2"
    }
   0.logic([1440,414],6,0,170)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1422,738],0,0,-1)
    {
    Vertex="0,0;0,-36"
    }
   -Wire-([1368,720],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1368,720],4,0,-1)
    {
    Name = "flt_en"
    }
   -Wire-([1422,648],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.logic([1458,666],0,0,190)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1422,648],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([1494,666],2,0,-1)
    {
    Name = "B3"
    }
   0.logic([1458,774],6,0,200)
    {
    Type = "1"
    Inv = "0"
    }
   -Wire-([1422,828],0,0,-1)
    {
    Vertex="0,0;-18,0"
    }
   0.datalabel([1494,774],4,0,-1)
    {
    Name = "B4"
    }
   -Wire-([1422,828],0,0,-1)
    {
    Vertex="0,0;0,-54"
    }
   0.tbreakn([1368,468],4,0,60)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B2T1"
    TO2 = "B2T2"
    }
   0.datamerge([1188,1080],4,0,210)
    {
    N = "4"
    Type = "1"
    Disp = "1"
    }
   0.datalabel([1170,1152],4,0,-1)
    {
    Name = "Fault"
    }
   -Wire-([1170,1152],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([702,702],4,0,-1)
    {
    Name = "Fault"
    }
   0.tbreakn([1368,648],4,0,100)
    {
    NUMS = "1"
    INIT = "0"
    TO1 = "B3T1"
    TO2 = "B3T2"
    }
   0.var([504,684],0,62990088,70)
    {
    Name = "Flt start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   -Sticky-([18,612],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,612,126,648
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "FAULT CONTROLS"
    }
   -ControlPanel-([18,252],0)
    {
    Name = "SOURCE 1"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,576,126
    Slider(63611856)
    Meter(63679120)
    Slider(63614632)
    Meter(63574256)
    Meter(63580248)
    Meter(63453496)
    Meter(63554168)
    Meter(63557080)
    }
   -Sticky-([18,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,198,144,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "PREFAULT CONTROLS"
    }
   -ControlPanel-([864,252],0)
    {
    Name = "Recorders"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,144,126
    Slider(63355344)
    Slider(63358456)
    }
   -Wire-([828,90],0,0,-1)
    {
    Vertex="0,0;0,504"
    }
   -Sticky-([864,198],0)
    {
    Name = ""
    Font = 1
    Bounds = 864,198,972,234
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Playback Recorders"
    }
   0.datalabel([1350,360],4,0,-1)
    {
    Name = "flt_en"
    }
   0.datalabel([1476,306],6,0,-1)
    {
    Name = "B1"
    }
   0.export([1224,1098],4,0,240)
    {
    Name = "BRKR"
    }
   0.export([1260,1152],4,0,220)
    {
    Name = "FLT"
    }
   0.var([504,720],0,63051720,80)
    {
    Name = "Flt duration"
    Group = ""
    Display = "0"
    Max = ".5"
    Min = "0.0"
    Value = "0.2"
    Units = "s"
    Collect = "1"
    }
   0.import([1332,1026],0,0,150)
    {
    Name = "Flt_en"
    }
   0.pgb([1206,1152],1,63055392,230)
    {
    Name = "<Untitled>"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-2.0"
    Max = "2.0"
    }
   -ControlPanel-([234,666],0)
    {
    Name = "Start & Duration"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Slider(62990088)
    Slider(63051720)
    Slider(63625096)
    }
   0.tfaultn([666,702],4,0,180)
    {
    TF = "Tfs"
    DF = "Tfd"
    }
   -ControlPanel-([18,666],0)
    {
    Name = "Fault Location and Type"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,216,126
    Dial(63642024)
    Dial(63676224)
    }
   -Sticky-([288,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 288,810,414,1026
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> A-g
  2=> B-g
  3=> C-g
  4=> AB-g
  5=> AC-g
  6=> BC-g
  7=> ABC-g
  8=> AB 
  9=> AC 
10=> no fault (0)"
    }
   -Sticky-([18,810],0)
    {
    Name = "Untitled"
    Font = 1
    Bounds = 18,810,270,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Dial Position:
  1=> FT1:
          Between Source and  breakers 
          (B1 and B3)
  2=> FT2: 
          Between B1 and Line1
  3=> FT3: 
          Midpoint on Line1
  4=> FT4: 
          Between Line1 and B2
  5=> FT5:
          Between breakers (B3 and B4)
          and Source
  6=> FT6:
          Between Line2 and B3
  7=> FT7:
          Midpoint on Line2
  8=> FT8:
          Between Line2 and B4"
    }
   -Sticky-([450,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 450,810,792,1134
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "\
Example of a Test  Sequence

Fault is located on Line 2 at B3 (Fault location 5).
Fault is ABC to Ground (Fault Type 7).

Fault occurs at  0.20 sec, Fault Duration 0.20 sec.

Set Breakers:
B1T1 =  2.00:  Breaker B1 does not trip
B2T1 =  2.00:  Breaker B1 does not trip
B3T1 =  0.35:  Breaker B3 trips in 35 msec
B4T1 =  0.36:  Breaker B4 trips in 35 msec
B1T2 =  2.00:  Breaker B1 does not reclose
B2T2 =  2.00:  Breaker B1 does not reclose
B3T2 =  2.00:  Breaker B3 does not reclose
B4T2 =  2.00:  Breaker B4 does not reclose

(Breaker  B1 and B2 do not automatically operate)

"
    }
   }
  }
 Module("Plots_B2")
  {
  Desc = ""
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Brush(Solid,Yellow)
   Rectangle(-24,-43,27,30)
   Line(-13,-1,-13,-21)
   Line(-13,-4,-4,-13)
   Line(-4,-13,1,-10)
   Line(6,-16,12,-13)
   Pen(Gray)
   Line(27,28,27,-43)
   Pen(Black)
   Line(1,-10,6,-16)
   Line(-18,-4,21,-4)
   Text(1,-28,"Plots")
   Text(3,24,"B2 B4")
   }


  Page(A/A4,Landscape,16,[597,467],100)
   {
   -Plot-([36,36],0)
    {
    Title = "Plots at B2"
    Draw = 1
    Area = [0,0,720,1152]
    Posn = [36,36]
    Icon = [-1,-1]
    Extents = 0,0,720,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63382640,"V2a",0,,,)
     Curve(63385552,"V2b",1,,,)
     Curve(63415392,"V2c",2,,,)
     }
    Graph([0,277],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63373800,"I2a",0,,,)
     Curve(63376928,"I2b",1,,,)
     Curve(63469816,"I2c",2,,,)
     }
    Graph([0,554],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63467048,"I20",0,,,)
     }
    PGraph([0,831],[0,0,720,258],"PolyGraph")
     {
     Options = 2
     Curve(63395368,"Br2a",0,,,1)
     Curve(63407232,"Br2b",1,,,1)
     Curve(63398008,"Br2c",2,,,1)
     }
    }
   -Plot-([792,36],0)
    {
    Title = "Plots at B4"
    Draw = 1
    Area = [0,0,720,1152]
    Posn = [792,36]
    Icon = [-1,-1]
    Extents = 0,0,720,1152
    XLabel = ""
    AutoPan = "false,75"
    Graph([0,0],[0,0,720,277],"Voltage")
     {
     Options = 9
     Units = ""
     Curve(63528152,"V4a",0,,,)
     Curve(63531064,"V4b",1,,,)
     Curve(63577336,"V4c",2,,,)
     }
    Graph([0,277],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63534152,"I4a",0,,,)
     Curve(63536928,"I4b",1,,,)
     Curve(63539840,"I4c",2,,,)
     }
    Graph([0,554],[0,0,720,277],"Current")
     {
     Options = 9
     Units = ""
     Curve(63542752,"I40",0,,,)
     }
    PGraph([0,831],[0,0,720,258],"PolyGraph")
     {
     Options = 2
     Curve(63323968,"Br4a",0,,,1)
     Curve(63565816,"Br4b",1,,,1)
     Curve(63568592,"Br4c",2,,,1)
     }
    }
   }
  }
 Module("Main")
  {
  Desc = "Main Page"
  FileDate = 0
  Nodes = 
   {
   }

  Graphics = 
   {
   Rectangle(-18,-18,18,18)
   }


  Page(B/A3,Landscape,16,[597,467],100)
   {
   0.pgb([2250,1242],0,63323968,1020)
    {
    Name = "Br4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.datalabel([324,1152],2,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([360,1152],2,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([396,1152],2,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([324,1332],2,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([360,1332],2,0,-1)
    {
    Name = "I2B"
    }
   0.datalabel([396,1332],2,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1764,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datatap([1782,1242],0,0,240)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1782,1278],0,0,340)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([216,1152],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([252,1152],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([288,1152],2,0,-1)
    {
    Name = "V1C"
    }
   0.datalabel([216,1332],6,0,-1)
    {
    Name = "V2A"
    }
   0.datalabel([252,1332],6,0,-1)
    {
    Name = "V2B"
    }
   0.datalabel([288,1332],6,0,-1)
    {
    Name = "V2C"
    }
   -Wire-([126,1260],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([144,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([126,1224],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([2214,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2214,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1926,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([2088,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datatap([1908,1314],0,0,400)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1908,1278],0,0,360)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1908,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1908,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1908,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1782,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1782,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1782,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1782,1314],0,0,380)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1908,1242],0,0,300)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1890,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.var([90,1224],0,63355344,130)
    {
    Name = "Start"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.15"
    Units = "s"
    Collect = "1"
    }
   0.var([90,1260],0,63358456,140)
    {
    Name = "Stop"
    Group = ""
    Display = "0"
    Max = "1.0"
    Min = "0.0"
    Value = "0.5"
    Units = "s"
    Collect = "1"
    }
   -Wire-([1926,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1800,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   0.datalabel([288,738],0,0,-1)
    {
    Name = "FT1"
    }
   0.pgb([1836,1530],0,63363472,450)
    {
    Name = "V3rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([774,540],0,0,-1)
    {
    Name = "FT2"
    }
   -Wire-([756,738],0,0,-1)
    {
    Vertex="0,0;0,18"
    }
   -Wire-([486,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([504,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([162,1440],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   -Wire-([486,1224],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([504,1260],0,0,-1)
    {
    Vertex="0,0;18,0"
    }
   0.datalabel([1152,1368],0,0,-1)
    {
    Name = "I1A"
    }
   0.datalabel([1152,1404],0,0,-1)
    {
    Name = "I1B"
    }
   0.datalabel([1152,1440],0,0,-1)
    {
    Name = "I1C"
    }
   0.datalabel([1278,1368],0,0,-1)
    {
    Name = "I2A"
    }
   0.datalabel([1278,1404],0,0,-1)
    {
    Name = "I2B"
    }
   0.pgb([1314,1368],0,63373800,970)
    {
    Name = "I2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1314,1404],0,63376928,910)
    {
    Name = "I2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1188,1314],0,63379728,290)
    {
    Name = "V1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1314,1242],0,63382640,180)
    {
    Name = "V2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.pgb([1314,1278],0,63385552,220)
    {
    Name = "V2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   0.datalabel([1440,1242],0,0,-1)
    {
    Name = "Br1A"
    }
   0.datalabel([1440,1278],0,0,-1)
    {
    Name = "Br1B"
    }
   0.datalabel([1440,1314],0,0,-1)
    {
    Name = "Br1C"
    }
   0.pgb([1476,1242],0,63391016,1090)
    {
    Name = "Br1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1566,1242],0,0,-1)
    {
    Name = "Br2A"
    }
   0.datalabel([1566,1278],0,0,-1)
    {
    Name = "Br2B"
    }
   0.pgb([1602,1242],0,63395368,1080)
    {
    Name = "Br2a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1602,1314],0,63398008,1000)
    {
    Name = "Br2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datalabel([1440,1368],0,0,-1)
    {
    Name = "P1"
    }
   0.pgb([1188,1278],0,63401680,200)
    {
    Name = "V1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1476,1278],0,63404456,1070)
    {
    Name = "Br1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1602,1278],0,63407232,1050)
    {
    Name = "Br2b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1134,1242],0,0,150)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1134,1278],0,0,190)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1116,1206],2,0,-1)
    {
    Name = "V1"
    }
   0.datalabel([1152,1242],2,0,-1)
    {
    Name = "V1A"
    }
   0.datalabel([1152,1278],2,0,-1)
    {
    Name = "V1B"
    }
   0.datalabel([1278,1278],2,0,-1)
    {
    Name = "V2B"
    }
   0.pgb([1314,1314],0,63415392,330)
    {
    Name = "V2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "300.0"
    }
   -Wire-([1440,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1440],0,0,-1)
    {
    Name = "S1W"
    }
   -Wire-([1440,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1440,1476],0,0,-1)
    {
    Name = "S1Q"
    }
   -Wire-([1566,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1566,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1476],0,0,-1)
    {
    Name = "S2Q"
    }
   0.datalabel([1278,1242],2,0,-1)
    {
    Name = "V2A"
    }
   0.pgb([1602,1368],0,63423184,920)
    {
    Name = "P2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.datalabel([1566,1440],0,0,-1)
    {
    Name = "S2W"
    }
   -Wire-([1566,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1404],0,0,-1)
    {
    Name = "Q2"
    }
   -Wire-([1566,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1368],0,0,-1)
    {
    Name = "P2"
    }
   -Wire-([1566,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1566,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1566,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1566,1314],0,0,-1)
    {
    Name = "Br2C"
    }
   0.datalabel([1278,1440],0,0,-1)
    {
    Name = "I2C"
    }
   -Wire-([1278,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1278,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1440],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1278],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1314],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1368],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1440,1404],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1314],2,0,-1)
    {
    Name = "V2C"
    }
   0.datatap([1260,1314],0,0,320)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1260,1278],0,0,210)
    {
    Index = "2"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1260,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1260,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1260,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datalabel([1152,1314],2,0,-1)
    {
    Name = "V1C"
    }
   -Wire-([1134,1314],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,1278],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([1134,1242],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   0.datatap([1134,1314],0,0,270)
    {
    Index = "3"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1440,1404],0,0,-1)
    {
    Name = "Q1"
    }
   0.pgb([1476,1314],0,63445520,1030)
    {
    Name = "Br1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.datatap([1260,1242],0,0,170)
    {
    Index = "1"
    Dim = "1"
    Type = "2"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1242,1206],2,0,-1)
    {
    Name = "V2"
    }
   -Wire-([1242,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.pgb([1602,1404],0,63450856,780)
    {
    Name = "Q2"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1476,1404],0,63453496,860)
    {
    Name = "Q1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([1188,1368],0,63456408,990)
    {
    Name = "I1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1188,1440],0,63459320,820)
    {
    Name = "I1c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   -Wire-([1278,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   -Wire-([1152,1476],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.pgb([1188,1476],0,63463072,710)
    {
    Name = "I10"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.075"
    Max = "0.15"
    }
   0.datalabel([1278,1476],0,0,-1)
    {
    Name = "I20"
    }
   0.pgb([1314,1476],0,63467048,680)
    {
    Name = "I20"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.1"
    Max = "0.1"
    }
   0.pgb([1314,1440],0,63469816,760)
    {
    Name = "I2c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1188,1404],0,63472728,940)
    {
    Name = "I1b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   -Wire-([1116,1206],0,0,-1)
    {
    Vertex="0,0;0,90"
    }
   0.datalabel([1152,1476],0,0,-1)
    {
    Name = "I10"
    }
   0.datalabel([1764,1206],2,0,-1)
    {
    Name = "V3"
    }
   0.datalabel([1800,1242],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([1800,1278],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([1800,1314],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([1926,1242],2,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([1926,1278],2,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([1926,1314],2,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([558,1152],2,0,-1)
    {
    Name = "V3A"
    }
   0.datalabel([594,1152],2,0,-1)
    {
    Name = "V3B"
    }
   0.datalabel([630,1152],2,0,-1)
    {
    Name = "V3C"
    }
   0.datalabel([558,1332],6,0,-1)
    {
    Name = "V4A"
    }
   0.datalabel([594,1332],6,0,-1)
    {
    Name = "V4B"
    }
   0.datalabel([630,1332],6,0,-1)
    {
    Name = "V4C"
    }
   0.datalabel([1800,1368],0,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([1800,1404],0,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([1800,1440],0,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([1800,1476],0,0,-1)
    {
    Name = "I30"
    }
   0.datalabel([1926,1368],0,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([1926,1404],0,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([1926,1440],0,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([1926,1476],0,0,-1)
    {
    Name = "I40"
    }
   0.datalabel([666,1152],2,0,-1)
    {
    Name = "I3A"
    }
   0.datalabel([702,1152],2,0,-1)
    {
    Name = "I3B"
    }
   0.datalabel([738,1152],2,0,-1)
    {
    Name = "I3C"
    }
   0.datalabel([666,1332],2,0,-1)
    {
    Name = "I4A"
    }
   0.datalabel([702,1332],2,0,-1)
    {
    Name = "I4B"
    }
   0.datalabel([738,1332],2,0,-1)
    {
    Name = "I4C"
    }
   0.datalabel([396,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([396,1476],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([2088,1368],0,0,-1)
    {
    Name = "P3"
    }
   0.datalabel([2088,1404],0,0,-1)
    {
    Name = "Q3"
    }
   0.datalabel([2088,1242],0,0,-1)
    {
    Name = "Br3A"
    }
   0.datalabel([2088,1278],0,0,-1)
    {
    Name = "Br3B"
    }
   0.datalabel([2088,1314],0,0,-1)
    {
    Name = "Br3C"
    }
   -Wire-([2214,1242],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([2214,1242],0,0,-1)
    {
    Name = "Br4A"
    }
   0.datalabel([2214,1278],0,0,-1)
    {
    Name = "Br4B"
    }
   0.datalabel([2214,1314],0,0,-1)
    {
    Name = "Br4C"
    }
   0.datalabel([2214,1368],0,0,-1)
    {
    Name = "P4"
    }
   0.datalabel([2214,1404],0,0,-1)
    {
    Name = "Q4"
    }
   0.pgb([1836,1242],0,63507704,260)
    {
    Name = "V3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1836,1278],0,63510536,350)
    {
    Name = "V3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1836,1314],0,63513448,390)
    {
    Name = "V3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1836,1368],0,63516360,850)
    {
    Name = "I3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1836,1404],0,63519440,740)
    {
    Name = "I3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1836,1440],0,63522328,660)
    {
    Name = "I3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.0"
    Max = "1.0"
    }
   0.pgb([1836,1476],0,63525240,610)
    {
    Name = "I30"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.08"
    Max = "0.01"
    }
   0.pgb([1962,1242],0,63528152,310)
    {
    Name = "V4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1962,1278],0,63531064,370)
    {
    Name = "V4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1962,1368],0,63534152,790)
    {
    Name = "I4a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1962,1404],0,63536928,690)
    {
    Name = "I4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1962,1440],0,63539840,620)
    {
    Name = "I4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-1.25"
    Max = "1.0"
    }
   0.pgb([1962,1476],0,63542752,600)
    {
    Name = "I40"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kA"
    mrun = "0"
    Pol = "0"
    Min = "-0.06"
    Max = "0.1"
    }
   0.pgb([2124,1242],0,63545664,1040)
    {
    Name = "Br3a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1278],0,63548608,980)
    {
    Name = "Br3b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1314],0,63551384,930)
    {
    Name = "Br3c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2124,1368],0,63554168,750)
    {
    Name = "P3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2124,1404],0,63557080,670)
    {
    Name = "Q3"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1368],0,63559992,720)
    {
    Name = "P4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   0.pgb([2250,1404],0,63562904,640)
    {
    Name = "Q4"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-50"
    Max = "50"
    }
   0.pgb([2250,1278],0,63565816,960)
    {
    Name = "Br4b"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([2250,1314],0,63568592,900)
    {
    Name = "Br4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = ""
    mrun = "0"
    Pol = "0"
    Min = "0.0"
    Max = "2.0"
    }
   0.pgb([1188,1242],0,63571344,160)
    {
    Name = "V1a"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-300.0"
    Max = "400.0"
    }
   0.pgb([1188,1530],0,63574256,430)
    {
    Name = "V1rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1962,1314],0,63577336,410)
    {
    Name = "V4c"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "-200.0"
    Max = "200.0"
    }
   0.pgb([1476,1368],0,63580248,950)
    {
    Name = "P1"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-150"
    Max = "150"
    }
   -Wire-([144,1224],0,0,-1)
    {
    Vertex="0,0;0,306"
    }
   -Wire-([162,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([504,1260],0,0,-1)
    {
    Vertex="0,0;0,288"
    }
   -Wire-([486,1224],0,0,-1)
    {
    Vertex="0,0;0,306"
    }
   -Wire-([486,1530],0,0,-1)
    {
    Vertex="0,0;-342,0"
    }
   -Wire-([504,1548],0,0,-1)
    {
    Vertex="0,0;-342,0"
    }
   0.pgb([1314,1530],0,63585696,440)
    {
    Name = "V2rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.pgb([1962,1530],0,63588608,460)
    {
    Name = "V4rms"
    Group = ""
    Display = "0"
    Scale = "1.0"
    Units = "kV"
    mrun = "0"
    Pol = "0"
    Min = "220"
    Max = "250"
    }
   0.datalabel([1494,666],0,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([936,594],0,0,-1)
    {
    Name = "FT3"
    }
   0.datalabel([936,810],0,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([954,1116],2,0,-1)
    {
    Name = "B2"
    }
   0.datalabel([990,1116],2,0,-1)
    {
    Name = "B3"
    }
   0.datalabel([918,1116],2,0,-1)
    {
    Name = "B1"
    }
   0.datatap([918,1116],6,0,550)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1026,1116],2,0,-1)
    {
    Name = "B4"
    }
   0.datatap([1026,1116],6,0,520)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1008,1134],0,0,-1)
    {
    Vertex="0,0;-126,0"
    }
   0.datalabel([2232,918],4,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([882,1134],0,0,-1)
    {
    Name = "Breakers"
    }
   0.datalabel([774,774],0,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([1134,774],0,0,-1)
    {
    Name = "FT8"
    }
   0.datalabel([2232,954],4,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([774,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1134,558],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([936,828],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([774,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1134,792],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1494,684],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([1890,1206],2,0,-1)
    {
    Name = "V4"
    }
   0.datalabel([738,1296],0,0,-1)
    {
    Name = "Fault"
    }
   0.datalabel([738,1476],0,0,-1)
    {
    Name = "Fault"
    }
   -Sticky-([1116,1116],0)
    {
    Name = ""
    Font = 1
    Bounds = 1116,1116,1224,1152
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "OUTPUT CHANNELS"
    }
   0.datalabel([936,612],0,0,-1)
    {
    Name = "Fault"
    }
   0.var([198,684],3,63611856,60)
    {
    Name = "Ph Angle"
    Group = "SS1"
    Display = "0"
    Max = "180"
    Min = "0.0"
    Value = "52.2"
    Units = "deg"
    Collect = "1"
    }
   0.var([144,684],3,63614632,50)
    {
    Name = "Voltage"
    Group = "SS1"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Sticky-([1512,486],0)
    {
    Name = ""
    Font = 1
    Bounds = 1512,486,1602,522
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 2"
    }
   0.var([1584,684],5,63617832,80)
    {
    Name = "Ph Angle"
    Group = "SS2"
    Display = "0"
    Max = "180"
    Min = "-180"
    Value = "20.0"
    Units = "deg"
    Collect = "1"
    }
   0.var([1638,684],5,63620936,90)
    {
    Name = "Voltage"
    Group = "SS2"
    Display = "0"
    Max = "500"
    Min = "0.0"
    Value = "230.0"
    Units = "kV"
    Collect = "1"
    }
   -Wire-([666,1530],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   0.datalabel([738,1530],0,0,-1)
    {
    Name = "Ron"
    }
   0.var([630,1530],0,63625096,420)
    {
    Name = "Rf"
    Group = ""
    Display = "0"
    Max = "50"
    Min = "0.001"
    Value = "0.001"
    Units = "ohm"
    Collect = "1"
    }
   0.tpflt([738,756],0,0,1230)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([1134,540],0,0,-1)
    {
    Name = "FT4"
    }
   0.tpflt([1170,522],4,0,1270)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([1170,756],4,0,1220)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.annotation([630,1512],0,0,-1)
    {
    AL1 = "Rf"
    AL2 = ""
    }
   0.datalabel([828,1206],2,0,-1)
    {
    Name = "FT1"
    }
   0.datalabel([864,1206],2,0,-1)
    {
    Name = "FT2"
    }
   0.datalabel([900,1206],2,0,-1)
    {
    Name = "FT3"
    }
   -Wire-([882,1296],0,0,-1)
    {
    Vertex="0,0;0,72"
    }
   0.datalabel([828,1458],0,0,-1)
    {
    Name = "F1"
    }
   0.datalabel([864,1458],0,0,-1)
    {
    Name = "F2"
    }
   0.datalabel([900,1458],0,0,-1)
    {
    Name = "F3"
    }
   0.datalabel([972,1206],2,0,-1)
    {
    Name = "FT5"
    }
   0.datalabel([1008,1458],0,0,-1)
    {
    Name = "F6"
    }
   0.var_pot([810,1332],0,63642024,230)
    {
    Name = "Fault location"
    Group = ""
    Display = "0"
    NDP = "8"
    Value = "5"
    F1 = "1.0"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "10.0"
    }
   0.unity([882,1332],0,0,250)
    {
    IType = "2"
    OType = "1"
    }
   0.datatap([828,1206],6,0,1180)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,1206],6,0,1170)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,1206],6,0,1160)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([972,1206],6,0,1140)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1008,1206],6,0,1130)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([936,1206],2,0,-1)
    {
    Name = "FT4"
    }
   0.datatap([828,1458],0,0,890)
    {
    Index = "1"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([864,1458],0,0,880)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([900,1458],0,0,870)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([936,1458],0,0,840)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([972,1458],0,0,830)
    {
    Index = "5"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1008,1206],2,0,-1)
    {
    Name = "FT6"
    }
   0.datalabel([972,1458],0,0,-1)
    {
    Name = "F5"
    }
   0.datalabel([936,1458],0,0,-1)
    {
    Name = "F4"
    }
   0.unity([918,1332],4,0,490)
    {
    IType = "2"
    OType = "1"
    }
   0.datalabel([918,1332],1,0,-1)
    {
    Name = "Faulttype"
    }
   -Wire-([918,1296],0,0,-1)
    {
    Vertex="0,0;0,36"
    }
   0.datalabel([918,1368],2,0,-1)
    {
    Name = "Fault"
    }
   0.datatap([990,1116],6,0,530)
    {
    Index = "3"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([936,1206],6,0,1150)
    {
    Index = "4"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1206],6,0,1120)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1044,1206],2,0,-1)
    {
    Name = "FT7"
    }
   0.datalabel([1080,1206],2,0,-1)
    {
    Name = "FT8"
    }
   -Wire-([1062,1224],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([1080,1206],6,0,1110)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   -Wire-([1062,1440],0,0,-1)
    {
    Vertex="0,0;-252,0"
    }
   0.datatap([1008,1458],0,0,810)
    {
    Index = "6"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1044,1458],0,0,800)
    {
    Index = "7"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datatap([1080,1458],0,0,770)
    {
    Index = "8"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1080,1458],0,0,-1)
    {
    Name = "F8"
    }
   0.datatap([954,1116],6,0,540)
    {
    Index = "2"
    Dim = "1"
    Type = "1"
    Style = "0"
    Disp = "1"
    }
   0.datalabel([1044,1458],0,0,-1)
    {
    Name = "F7"
    }
   0.mux_array([900,1404],6,0,510)
    {
    DPath = "0"
    }
   0.mux_array([900,1260],0,0,1100)
    {
    DPath = "0"
    }
   0.var_pot([990,1332],2,63676224,280)
    {
    Name = "Fault Type"
    Group = ""
    Display = "0"
    NDP = "10"
    Value = "7"
    F1 = "1"
    F2 = "2.0"
    F3 = "3.0"
    F4 = "4.0"
    F5 = "5.0"
    F6 = "6.0"
    F7 = "7.0"
    F8 = "8.0"
    F9 = "9.0"
    F10 = "0"
    }
   0.pgb([1476,1440],0,63679120,730)
    {
    Name = "PS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1476,1476],0,63682112,650)
    {
    Name = "QS1"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.pgb([1602,1440],0,63685024,700)
    {
    Name = "PS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MW"
    mrun = "0"
    Pol = "0"
    Min = "-300"
    Max = "300"
    }
   0.pgb([1602,1476],0,63687936,630)
    {
    Name = "QS2"
    Group = ""
    Display = "0"
    Scale = "1"
    Units = "MVAR"
    mrun = "0"
    Pol = "0"
    Min = "-100"
    Max = "100"
    }
   0.recorder2_0([288,1404],0,0,1060)
    {
    FName = "stn2"
    FFMT = "0"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "2"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([630,1404],0,0,1010)
    {
    FName = "stn4"
    FFMT = "0"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "4"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V2a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V2b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V2c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I2a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I2b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I2c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([288,1224],0,0,1200)
    {
    FName = "stn1"
    FFMT = "0"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "1"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "1"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "1"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "1"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = "1"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = "1"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = "1"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.recorder2_0([630,1224],0,0,1190)
    {
    FName = "stn3"
    FFMT = "0"
    Rstep = "50"
    Mfilter = "0"
    FREQ = "1"
    StnN = "EMTDC_Simulation"
    DevNo = "3"
    NChA = "6"
    NChD = "1"
    ABFMT = "0"
    MFILE = "0"
    NxHdr = "0"
    AMin = "0"
    AMax = "4096"
    ENTCAP = "0"
    Hdr1 = "Extra_Line_1"
    Hdr2 = "Extra_Line_2"
    Hdr3 = "Extra_Line_3"
    Hdr4 = "Extra_Line_4"
    Hdr5 = "Extra_Line_5"
    NA1 = "V1a"
    DA1 = "A1"
    VS1 = "0"
    VT1 = "0"
    UN1 = "A1"
    PH1 = "0"
    TR1 = "2"
    CT1 = "A1"
    NA2 = "V1b"
    DA2 = "A2"
    VS2 = "0"
    VT2 = "0"
    UN2 = "A2"
    PH2 = "0"
    TR2 = "2"
    CT2 = "A2"
    NA3 = "V1c"
    DA3 = "A3"
    VS3 = "0"
    VT3 = "0"
    UN3 = "A3"
    PH3 = "0"
    TR3 = "2"
    CT3 = "A3"
    NA4 = "I1a"
    DA4 = "A4"
    VS4 = "0"
    VT4 = "1"
    UN4 = "A4"
    PH4 = "0"
    TR4 = ".2"
    CT4 = "A4"
    NA5 = "I1b"
    DA5 = "A5"
    VS5 = "0"
    VT5 = "1"
    UN5 = "A5"
    PH5 = "0"
    TR5 = ".2"
    CT5 = "A5"
    NA6 = "I1c"
    DA6 = "A6"
    VS6 = "0"
    VT6 = "1"
    UN6 = "A6"
    PH6 = "0"
    TR6 = ".2"
    CT6 = "A6"
    NA7 = "A7"
    DA7 = "A7"
    VS7 = "0"
    VT7 = "0"
    UN7 = "A7"
    PH7 = "0"
    TR7 = "1"
    CT7 = "A7"
    NA8 = "A8"
    DA8 = "A8"
    VS8 = "0"
    VT8 = "0"
    UN8 = "A8"
    PH8 = "0"
    TR8 = "1"
    CT8 = "A8"
    NA9 = "A9"
    DA9 = "A9"
    VS9 = "0"
    VT9 = "0"
    UN9 = "A9"
    PH9 = "0"
    TR9 = "1"
    CT9 = "A9"
    NA10 = "A10"
    DA10 = "A10"
    VS10 = "0"
    VT10 = "0"
    UN10 = "A10"
    PH10 = "0"
    TR10 = "1"
    CT10 = "A10"
    NA11 = "A11"
    DA11 = "A11"
    VS11 = "0"
    VT11 = "0"
    UN11 = "A11"
    PH11 = "0"
    TR11 = "1"
    CT11 = "A11"
    NA12 = "A12"
    DA12 = "A12"
    VS12 = "0"
    VT12 = "0"
    UN12 = "A12"
    PH12 = "0"
    TR12 = "1.0"
    CT12 = "A12"
    ND1 = "D1"
    DD1 = "D1"
    NT1 = "0"
    ND2 = "D2"
    DD2 = "D2"
    NT2 = "0"
    ND3 = "D3"
    DD3 = "D3"
    NT3 = "0"
    ND4 = "D4"
    DD4 = "D4"
    NT4 = "0"
    ND5 = "D5"
    DD5 = "D5"
    NT5 = "0"
    ND6 = "D6"
    DD6 = "D6"
    NT6 = "0"
    ND7 = "D7"
    DD7 = "D7"
    NT7 = "0"
    ND8 = "D8"
    DD8 = "D8"
    NT8 = "0"
    ND9 = "D9"
    DD9 = "D9"
    NT9 = "0"
    ND10 = "D10"
    DD10 = "D10"
    NT10 = "0"
    ND11 = "D11"
    DD11 = "D11"
    NT11 = "0"
    ND12 = "D12"
    DD12 = "D12"
    NT12 = "0"
    ND13 = "D13"
    DD13 = "D13"
    NT13 = "0"
    ND14 = "D14"
    DD14 = "D14"
    NT14 = "0"
    ND15 = "D15"
    DD15 = "D15"
    NT15 = "0"
    ND16 = "D16"
    DD16 = "D16"
    NT16 = "0"
    }
   0.breaker3([1260,522],0,0,580)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B2"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I2A"
    IBRB = "I2B"
    IBRC = "I2C"
    IBR0 = "I20"
    SBRA = "Br2A"
    SBRB = "Br2B"
    SBRC = "Br2C"
    BP = "P2"
    BQ = "Q2"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "-134.3"
    Q = "10.96"
    }
   -Wire-([1188,738],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   0.tpflt([1530,648],4,0,1240)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.var_switch([198,936],0,63740424,110)
    {
    Name = "B5"
    Group = ""
    Display = "0"
    Value = "1"
    Max = "1"
    Min = "0"
    Ton = "ON"
    Toff = "OFF"
    }
   0.datalabel([288,756],0,0,-1)
    {
    Name = "Fault"
    }
   0.tpflt([252,720],0,0,1250)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.datalabel([2232,972],4,0,-1)
    {
    Name = "FaultType"
    }
   -Wire-([2304,972],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([2304,954],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([2304,918],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   0.tpflt([738,522],0,0,1290)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([972,576],4,0,1260)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   0.tpflt([972,792],4,0,1210)
    {
    Ctype = "1"
    OpCur = "0"
    Grnd = "1"
    View = "1"
    CLVL = "0.0"
    RON = "Ron"
    ROFF = "1.0E6 [ohm]"
    A = "1"
    B = "0"
    C = "0"
    G = "1"
    Ifla = ""
    Iflb = ""
    Iflc = ""
    AG1 = "0"
    }
   -Wire-([1188,522],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Sticky-([990,810],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,810,1026,846
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Line 2"
    }
   -Sticky-([414,738],0)
    {
    Name = ""
    Font = 1
    Bounds = 414,738,450,774
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Line 4"
    }
   -Wire-([846,738],0,0,-1)
    {
    Vertex="0,0;-90,0"
    }
   -Wire-([846,522],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1134,522],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Wire-([1134,738],0,0,-1)
    {
    Vertex="0,0;-72,0"
    }
   -Bus-([1296,486],0,51570040,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Bus-([594,486],0,51570312,-1)
    {
    P1 = [0,0]
    P2 = [0,288]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Wire-([1512,612],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Bus-([1512,576],0,51570760,-1)
    {
    P1 = [0,0]
    P2 = [0,72]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   -Wire-([270,612],0,0,-1)
    {
    Vertex="0,0;-54,0"
    }
   -Sticky-([414,468],0)
    {
    Name = ""
    Font = 1
    Bounds = 414,468,450,504
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Line 3"
    }
   -Sticky-([990,432],0)
    {
    Name = ""
    Font = 1
    Bounds = 990,432,1026,468
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Line 1"
    }
   -Wire-([594,558],0,0,-1)
    {
    Vertex="0,0;-36,0"
    }
   0.breaker3([522,558],4,0,1280)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B5"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I5A"
    IBRB = "I5B"
    IBRC = "I5C"
    IBR0 = "I50"
    SBRA = "Br5A"
    SBRB = "Br5B"
    SBRC = "Br5C"
    BP = "P5"
    BQ = "Q5"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.002938"
    Q = "-0.01091"
    }
   -Wire-([594,684],0,0,-1)
    {
    Vertex="0,0;-108,0"
    }
   0.source3R([180,612],6,0,470)
    {
    Name = "Source1"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "17.95 [ohm]"
    Phi1 = "87.63 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "14.99 [ohm]"
    Phi0 = "80.86 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S1W"
    Q = "S1Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([126,504],0)
    {
    Name = ""
    Font = 1
    Bounds = 126,504,216,540
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "SUBSTATION 1"
    }
   0.source3R([1602,612],2,0,480)
    {
    Name = "Source2"
    MVA = "100.0 [MVA]"
    Vm = "230.0 [kV]"
    F = "$(f)"
    Tc = "0.05 [s]"
    Ideal = "0"
    ZSeq = "1"
    Imp = "1"
    View = "1"
    details = "1"
    Z1 = "3.8 [ohm]"
    Phi1 = "87.69 [deg]"
    R1p = "1.0 [ohm]"
    X1p = "0.1 [ohm]"
    Z0 = "6.02 [ohm]"
    Phi0 = "80.9 [deg]"
    R0p = "1.0 [ohm]"
    X0p = "0.1 [ohm]"
    P = "S2W"
    Q = "S2Q"
    Ia = ""
    Ib = ""
    Ic = ""
    }
   -Sticky-([1440,522],0)
    {
    Name = ""
    Font = 1
    Bounds = 1440,522,1476,558
    Alignment = 0
    Style = 1
    Arrow = 0
    Color = 0,15792890
    Text = "Line 5"
    }
   .Plots_B2([1260,396],0,0,20)
    {
    }
   0.breaker3([630,522],4,0,590)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B1"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I1A"
    IBRB = "I1B"
    IBRC = "I1C"
    IBR0 = "I10"
    SBRA = "Br1A"
    SBRB = "Br1B"
    SBRC = "Br1C"
    BP = "P1"
    BQ = "Q1"
    BOpen1 = "0"
    BOpen2 = "0"
    BOpen3 = "0"
    P = "138"
    Q = "-10.95"
    }
   -Wire-([702,738],0,0,-1)
    {
    Vertex="0,0;54,0"
    }
   -Wire-([702,522],0,0,-1)
    {
    Vertex="0,0;72,0"
    }
   -ControlPanel-([72,882],0)
    {
    Name = "B5 Control"
    Flags = 0
    State = 1
    Icon = -1,-1
    Posn = -1,-1
    Extents = 0,0,72,126
    Switch(63740424)
    }
   -Bus-([270,522],0,51586112,-1)
    {
    P1 = [0,0]
    P2 = [0,198]
    I = 1
    BASKV = 0
    IDE = 0
    GL = 0
    BL = 0
    AREA = 1
    ZONE = 0
    VM = 0
    VA = 0
    OWNER = 1
    }
   0.pi_section2([378,558],0,0,-1)
    {
    Name = "Line3"
    PU = "1"
    F = "$(f)"
    len = "1.0 [m]"
    Estim = "0"
    View = "1"
    ConNeed = "0"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "8.14944 [ohm/m]"
    Xp = "77.1472 [ohm/m]"
    Bp = "5.46e-4 [mho/m]"
    Rz = "36.6064 [ohm/m]"
    Xz = "243.776 [ohm/m]"
    Bz = "3.88e-4 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.pi_section2([378,684],0,0,-1)
    {
    Name = "Line4"
    PU = "1"
    F = "$(f)"
    len = "1.0 [m]"
    Estim = "0"
    View = "1"
    ConNeed = "0"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "8.14944 [ohm/m]"
    Xp = "77.1472 [ohm/m]"
    Bp = "5.46e-4 [mho/m]"
    Rz = "36.6064 [ohm/m]"
    Xz = "243.776 [ohm/m]"
    Bz = "3.88e-4 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.pi_section2([954,522],0,0,-1)
    {
    Name = "Line1"
    PU = "1"
    F = "$(f)"
    len = "1.0 [m]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "8.19589 [ohm/m]"
    Xp = "77.5869 [ohm/m]"
    Bp = "5.46e-4 [mho/m]"
    Rz = "36.81506 [ohm/m]"
    Xz = "245.166 [ohm/m]"
    Bz = "3.88e-4 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.pi_section2([1404,612],0,0,-1)
    {
    Name = "Line5"
    PU = "1"
    F = "$(f)"
    len = "1.0 [m]"
    Estim = "0"
    View = "1"
    ConNeed = "0"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "4.09795 [ohm/m]"
    Xp = "38.79347 [ohm/m]"
    Bp = "2.73e-4 [mho/m]"
    Rz = "18.40753 [ohm/m]"
    Xz = "122.583 [ohm/m]"
    Bz = "1.94e-4 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.breaker3([630,738],4,0,570)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B3"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I3A"
    IBRB = "I3B"
    IBRC = "I3C"
    IBR0 = "I30"
    SBRA = "Br3A"
    SBRB = "Br3B"
    SBRC = "Br3C"
    BP = "P3"
    BQ = "Q3"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05708"
    Q = "0.04893"
    }
   0.breaker3([1260,738],0,0,560)
    {
    Ctrl = "0"
    OPCUR = "0"
    ENAB = "0"
    CLVL = "0.0"
    View = "1"
    ViewB = "1"
    DisPQ = "1"
    NAME = "B4"
    NAMEA = "BRKA"
    NAMEB = "BRKB"
    NAMEC = "BRKC"
    ROFF = "1.0e6 [ohm]"
    RON = "0.1 [ohm]"
    PRER = "0.5 [ohm]"
    TDA = "0.0 [s]"
    TDB = "0.0 [s]"
    TDC = "0.0 [s]"
    TDRA = "0.05 [s]"
    TDRB = "0.05 [s]"
    TDRC = "0.05 [s]"
    PostIns = "0"
    TDBOA = "0.005"
    IBRA = "I4A"
    IBRB = "I4B"
    IBRC = "I4C"
    IBR0 = "I40"
    SBRA = "Br4A"
    SBRB = "Br4B"
    SBRC = "Br4C"
    BP = "P4"
    BQ = "Q4"
    BOpen1 = "2"
    BOpen2 = "2"
    BOpen3 = "2"
    P = "0.05154"
    Q = "-0.02667"
    }
   .Controls([2340,954],4,0,500)
    {
    }
   .Plots_B1([630,396],0,0,10)
    {
    }
   -Sticky-([18,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 18,18,486,198
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This example system is taken from the SEL 321 Relay Instruction Manual, Chapter 5. 

The transmission line models are based on inputting R, X, and B data manually.
Line data is entered per meter; therefore, the lengths of the different 
line sections are adjusted simply by changing the line length.
"
    }
   0.pi_section2([954,738],0,0,-1)
    {
    Name = "Line2"
    PU = "1"
    F = "$(f)"
    len = "1.0 [m]"
    Estim = "0"
    View = "1"
    ConNeed = "1"
    Percent = "50 [%]"
    REst = "1.5"
    ZEst = "1.5"
    TEst = "1.5"
    Rp = "8.19589 [ohm/m]"
    Xp = "77.5869 [ohm/m]"
    Bp = "5.46e-4 [mho/m]"
    Rz = "36.81506 [ohm/m]"
    Xz = "245.166 [ohm/m]"
    Bz = "3.88e-4 [mho/m]"
    VR2 = "230.0 [kV]"
    MVA2 = "100.0 [MVA]"
    RPUP2 = ".336786E-7 [pu/m]"
    XLPUP2 = ".593346E-6 [pu/m]"
    BPUP2 = "1.93387E-6 [pu/m]"
    RPUZ2 = ".558072E-6 [pu/m]"
    XLPUZ2 = ".196578E-5 [pu/m]"
    BPUZ2 = "1.27727E-6 [pu/m]"
    }
   0.datalabel([270,936],0,0,-1)
    {
    Name = "B5"
    }
   0.unity([270,936],0,0,120)
    {
    IType = "2"
    OType = "1"
    }
   -Sticky-([522,18],0)
    {
    Name = ""
    Font = 1
    Bounds = 522,18,918,126
    Alignment = 0
    Style = 0
    Arrow = 0
    Color = 0,15792890
    Text = "\
This case uses global substitutions.  To change between 50Hz/60Hz. select Global Substitutions (Ctrl-G).  In the pop-up window, change the value of f to the desired frequency.
"
    }
   -Divider-([36,1044],0)
    {
    Size(2376,0)
    3D = 1
    Color = 9
    Style = 0
    Weight = 2
    }
   0.multimeter([684,522],0,0,30)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V1"
    P = ""
    Q = ""
    Vrms = "V1rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([684,738],0,0,70)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V3"
    P = ""
    Q = ""
    Vrms = "V3rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1206,738],4,0,100)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V4"
    P = ""
    Q = ""
    Vrms = "V4rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   0.multimeter([1206,522],4,0,40)
    {
    MeasI = "0"
    MeasV = "1"
    MeasP = "0"
    MeasQ = "0"
    RMS = "1"
    MeasPh = "0"
    S = "1.0 [MVA]"
    BaseV = "1.0 [kV]"
    TS = "0.02 [s]"
    Freq = "60.0 [Hz]"
    Dis = "0"
    CurI = ""
    VolI = "V2"
    P = ""
    Q = ""
    Vrms = "V2rms"
    Ph = ""
    hide1 = "0"
    hide2 = "0"
    Pd = ""
    Qd = ""
    Vd = ""
    }
   -Wire-([1152,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1152,1530],0,0,-1)
    {
    Name = "V1rms"
    }
   -Wire-([1278,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1278,1530],0,0,-1)
    {
    Name = "V2rms"
    }
   -Wire-([1800,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1800,1530],0,0,-1)
    {
    Name = "V3rms"
    }
   -Wire-([1926,1530],0,0,-1)
    {
    Vertex="0,0;36,0"
    }
   0.datalabel([1926,1530],0,0,-1)
    {
    Name = "V4rms"
    }
   }
  }
 }

